
##################### TileEngine Scrolling demo #####################
label TileEngineScroll:
call ChooseIsometricOrStraight from _TileEngineScroll_ChooseIsometricOrStraight
call CombatMap from _TileEngineScroll_CombatMap
$ e = TileEngine(geometry=Geom, map=map, tilewidth=tilewidth, tileheight=tileheight, show_cursor=True, cursor_sprite=cursor_sprite, movement_duration=2.0, draggable=True)
tohko "I'm about to display the map, with the TileEngine's Show() function."
$ e.Show(interactions=False)
tohko "There it is. Now, I'm about to move a sprite from position (0,0) to (2,2)."
$ e.Cursor.MoveTo((2,2))
$ e.Show()
tohko "You can do this kind of thing in the background, behind VN segments, like this."
$ e.Hide()
tohko "And we can hide it whenever we want."
tohko "Another thing we can do is use the View() function to let the user scroll around, with mouse or keyboard. You can also drag the map to scroll, if you specify draggable=True. Take a look. When you're done, you can click the button, or press Escape or Q."
$ e.View()
tohko "All right, let's see something more interesting."
return




##################### UnitEngine Combat demo #####################
label UnitEngineCombat:
tohko "All right, now you can choose some other aspects of the UnitEngine. Click Run! when you're ready to go!"

python:
  # Use my own little config screen to specify these parameters
  params = Struct(
    geometry = TileEngine.ISOMETRIC,
    movement_style = UnitEngine.MP,
    movement_directions = 8,
    allow_moving_through_units = True,
    always_confirm_end_turn = False,
    moving_sprite_status="",
    start = False)

  while params.start == False:
    ShowDemoConfigScreen()
    func = ui.interact()
    func()

# Get the geometry-specific definitions
call SetupDefinitions from _CombatDemo_SetupDefinitions
# Define the map
call CombatMap from _CombatDemo_CombatMap

python:
  # Create the combat object
  e = TacticsCombat(map=map,
          tilewidth=tilewidth,
          tileheight=tileheight,
          background="blue",
          show_cursor=True,
          cursor_sprite=cursor_sprite,
          move_square_highlight=move_square_highlight,
          act_square_highlight=act_square_highlight,
          movement_duration=1.0,
          unit_highlight=unit_highlight,
          unit_highlight_function=unit_highlight_function,
          **(params.__dict__))


  # Player units
  Comtron1 = e.Unit(
    name = "Firebox",
    sprite_base_name = "unit-lightbot.png", # It doesn't matter that this image itself doesn't exist,
    character = TOHKO,
    direction_facing = e.DIR_NW,            # because it'll always have a direction inserted before the dot
    max_HP = 50,
    max_MP = 3,
    weapons = [ TacticsCombat.RIFLE ],
    items = [ ],
    selected_weapon = TacticsCombat.RIFLE,
    actions = {"action": e.ReturnActionFunction()},
    position = (4, 4),
    visible_by_allies = [ ],
    visible_by_enemies = [ ]
    )
  Comtron2 = e.Unit(
    name = "Elfbox",
    sprite_base_name = "unit-lightbot.png",
    character = ASILANA,
    direction_facing = e.DIR_SW,
    max_HP = 50,
    max_MP = 3,
    weapons = [ TacticsCombat.MEDIKIT, TacticsCombat.RIFLE ],
    items = [ ],
    selected_weapon = TacticsCombat.MEDIKIT,
    actions = {"action": e.ReturnActionFunction()},
    position = (8, 1),
    visible_by_allies = [ ],
    visible_by_enemies = [ ]
    )

  # Enemy units
  Daleks = [ ]
  for thisDalekNum in [1, 2]:
    Daleks.append( e.Unit(
      name = "Dalek %d" % thisDalekNum,
      sprite_base_name = "unit-dalek.png", # Also doesn't exist, but will have a direction inserted
      controller = UnitEngine.ENEMY,
      info_string = "A strangely familiar enemy.\nTheir lasers have a\nrange of 4 squares.",
      direction_facing = e.DIR_SE,
      max_HP = 50,
      max_MP = 2,
      weapons = [ TacticsCombat.LASER ],
      items = [ ],
      selected_weapon = TacticsCombat.LASER,
      actions = {"attack": e.ReturnDalekAttackFunction()},
      position = (thisDalekNum, 0),
      visible_by_allies = [ ],
      visible_by_enemies = [ ]
      ) )

  # Start the game
  e.StartGame()

  # When we're done with the game, store whether we won or lost, but then delete the object
  # This lets rollback and saving the game work again <.<
  endMode = e.mode
  del(e)

if endMode == UnitEngine.VICTORY:
  tohko "Woohoo! We beat those strange purple robots!"
else:
  tohko "Oh dear, beaten up by a bunch of robots."
  tohko "It must be being encased in those boxy blue suits that did it."
tohko "Time for another demo - or another go at this one?"
return


init python:
  def ShowDemoConfigScreen():
    button_params = {"xalign": 0.5, "yalign": 0.5, "size_group": "buttons"}
    label_params  = {"xalign": 0.0, "yalign": 0.5, "size_group": "labels"}

    ui.window(style=style.engine_frame, xalign=0.5, yalign=0.5, xfill=False)
    ui.vbox() # Main layout
    engine_label("Set UnitEngine parameters", xalign=0.5)
    ui.null(height=15)

    ui.hbox() # Geometry row
    engine_label("Geometry: ", **label_params)
    engine_button("Isometric", clicked=ui.returns(SetGeom(TileEngine.ISOMETRIC)), role=SelectedIf(params.geometry == TileEngine.ISOMETRIC), **button_params)
    engine_button("Straight", clicked=ui.returns(SetGeom(TileEngine.STRAIGHT)), role=SelectedIf(params.geometry == TileEngine.STRAIGHT), **button_params)
    ui.close() # End of geometry row

#     #ui.hbox() # Movement style row
#     engine_label("Movement style: ", yalign=0.5)
#     engine_button("Movement\nPoints (MP)", clicked=ui.returns(SetMStyle(UnitEngine.MP)), role=SelectedIf(params.movement_style == UnitEngine.MP), xalign=0.5, yalign=0.5)
#     engine_button("Action\nPoints (AP)", clicked=ui.returns(SetMStyle(UnitEngine.AP)), role=SelectedIf(params.movement_style == UnitEngine.AP), xalign=0.5, yalign=0.5)
#     #ui.close() # End of movement style row

    ui.hbox() # Movement directions row
    engine_label("Movement directions: ", **label_params)
    engine_button("4", clicked=ui.returns(SetDirs(4)), role=SelectedIf(params.movement_directions == 4), **button_params)
    engine_button("8", clicked=ui.returns(SetDirs(8)), role=SelectedIf(params.movement_directions == 8), **button_params)
    ui.close() # End of movement style row

    ui.hbox() # Movement through units row
    engine_label("Allow movement\nthrough units: ", **label_params)
    engine_button("False", clicked=ui.returns(SetMoveThru(False)), role=SelectedIf(params.allow_moving_through_units == False), **button_params)
    engine_button("True", clicked=ui.returns(SetMoveThru(True)), role=SelectedIf(params.allow_moving_through_units == True), **button_params)
    ui.close() # End of through units row
    #ui.close() # End of grid

    ui.null(height=30)
    engine_button("Run!", clicked=ui.returns(StartUnitCombatDemo), xalign=0.5)
    ui.close() # End of main vbox

  def SelectedIf(bool):
    if bool:
      return "selected_"
    else:
      return ""
  @renpy.curry
  def SetGeom(val):
    params.geometry = val
  @renpy.curry
  def SetMStyle(val):
    params.movement_style = val
  @renpy.curry
  def SetDirs(val):
    params.movement_directions = val
  @renpy.curry
  def SetMoveThru(val):
    params.allow_moving_through_units = val

  def StartUnitCombatDemo():
    params.start = True



##################### Shared combat demo code #####################


# ChooseIsometricOrStraight is shared between the TileEngine scrolling demo and the UnitEngine combat demo
label ChooseIsometricOrStraight:
tohko "Would you like to see this demo in isometric or straight-grid view?"
menu:
  "Isometric!":
    call IsometricDefinitions from _ChooseIsometricOrStraight_IsometricDefinitions
  "Straight!":
    call StraightDefinitions from _ChooseIsometricOrStraight_StraightDefinitions
return


label SetupDefinitions:
if params.geometry == TileEngine.ISOMETRIC:
  jump IsometricDefinitions
else:
  jump StraightDefinitions

label IsometricDefinitions:
  python:
    move_square_highlight = ("tile-highlight-iso-blue.png","tile-highlight-iso-blue-selected.png")
    act_square_highlight = ("tile-highlight-iso-red.png", "tile-highlight-iso-red-selected.png")
    f = MyFilmstrip(framesize=(64,31), gridsize=(2,3), delay=0.1)
    unit_highlight = im.Alpha("tile-highlight-iso-green-animstrip.png", 0.5)
    unit_highlight_function = f.Create
    cursor_sprite = "cursor-iso.png"
    Geom = TileEngine.ISOMETRIC
    tilewidth = 64
    tileheight = 32

    # Provide the isometric definitions of the tiles
    tile = Struct(
      terrain_type = UnitEngine.TT_GROUND,
      lower = "tile-tiles-iso.png",
      upper = None)
    rock = Struct(
      terrain_type = UnitEngine.TT_GROUND,
      lower = "tile-rocks-iso.png",
      upper = None)
    grass = Struct(
      terrain_type = UnitEngine.TT_GROUND,
      lower = "tile-grass-iso.png",
      upper = None)
    wall = Struct(
      terrain_type = UnitEngine.TT_WALL,
      lower = None,
      upper = "abovetile-wall-iso.png")
    # Two different tree tiles are composed of grass+tree and tiles+tree
    gtree = Struct(
      terrain_type = UnitEngine.TT_WALL,
      lower = "tile-grass-iso.png",
      upper = "abovetile-tree.png")
    ttree = Struct(
      terrain_type = UnitEngine.TT_WALL,
      lower = "tile-tiles-iso.png",
      upper = "abovetile-tree.png")
  return

label StraightDefinitions:
  python:
    move_square_highlight = ("tile-highlight-straight-blue.png","tile-highlight-straight-blue-selected.png")
    act_square_highlight = ("tile-highlight-straight-red.png", "tile-highlight-straight-red-selected.png")
    f = MyFilmstrip(framesize=(64,64), gridsize=(2,3), delay=0.1)
    unit_highlight = im.Alpha("tile-highlight-straight-green-animstrip.png", 0.5)
    unit_highlight_function = f.Create
    cursor_sprite = "cursor-straight.png"
    Geom = TileEngine.STRAIGHT
    tilewidth = 64
    tileheight = 64

    # Provide the straight definitions of the tiles
    tile = Struct(
      terrain_type = UnitEngine.TT_GROUND,
      lower = "tile-tiles-straight.png",
      upper = None)
    rock = Struct(
      terrain_type = UnitEngine.TT_GROUND,
      lower = "tile-rocks-straight.png",
      upper = None)
    grass = Struct(
      terrain_type = UnitEngine.TT_GROUND,
      lower = "tile-grass-straight.png",
      upper = None)
    wall = Struct(
      terrain_type = UnitEngine.TT_WALL,
      lower = None,
      upper = "abovetile-wall-straight.png")
    # Two different tree tiles are composed of grass+tree and tiles+tree
    gtree = Struct(
      terrain_type = UnitEngine.TT_WALL,
      lower = "tile-grass-straight.png",
      upper = "abovetile-tree.png")
    ttree = Struct(
      terrain_type = UnitEngine.TT_WALL,
      lower = "tile-tiles-straight.png",
      upper = "abovetile-tree.png")
  return



label CombatMap:
python:
  map = [
     [c(grass), c(grass), c(rock ), c(grass), c(rock ), c(tile ), c(tile ), c(wall ), c(tile ), c(tile )],
     [c(grass), c(rock ), c(grass), c(rock ), c(grass), c(ttree), c(tile ), c(wall ), c(tile ), c(tile )],
     [c(grass), c(grass), c(rock ), c(grass), c(rock ), c(tile ), c(tile ), c(wall ), c(tile ), c(tile )],
     [c(rock ), c(grass), c(rock ), c(grass), c(rock ), c(ttree), c(tile ), c(wall ), c(tile ), c(tile )],
     [c(grass), c(grass), c(grass), c(rock ), c(grass), c(tile ), c(tile ), c(wall ), c(tile ), c(tile )],

     [c(rock ), c(grass), c(gtree), c(grass), c(grass), c(ttree), c(tile ), c(wall ), c(tile ), c(tile )],
     [c(grass), c(grass), c(grass), c(rock ), c(rock ), c(tile ), c(tile ), c(wall ), c(tile ), c(tile )],
     [c(grass), c(rock ), c(grass), c(grass), c(grass), c(ttree), c(tile ), c(tile ), c(tile ), c(tile )],
     [c(rock ), c(grass), c(rock ), c(grass), c(rock ), c(tile ), c(tile ), c(wall ), c(tile ), c(tile )],
     [c(grass), c(rock ), c(grass), c(rock ), c(grass), c(ttree), c(tile ), c(wall ), c(tile ), c(tile )],

     [c(grass), c(gtree), c(gtree), c(gtree), c(rock ), c(tile ), c(tile ), c(wall ), c(tile ), c(tile )],
     [c(rock ), c(grass), c(grass), c(grass), c(rock ), c(tile ), c(tile ), c(wall ), c(tile ), c(tile )],
     [c(rock ), c(rock ), c(rock ), c(grass), c(rock ), c(tile ), c(tile ), c(wall ), c(tile ), c(tile )],
     [c(tile ), c(ttree), c(tile ), c(ttree), c(tile ), c(ttree), c(tile ), c(tile ), c(tile ), c(tile )],
     [c(tile ), c(tile ), c(tile ), c(tile ), c(tile ), c(tile ), c(tile ), c(wall ), c(tile ), c(tile )],

     [c(wall ), c(wall ), c(wall ), c(wall ), c(wall ), c(tile ), c(wall ), c(wall ), c(tile ), c(tile )],
     [c(tile ), c(tile ), c(tile ), c(tile ), c(tile ), c(tile ), c(tile ), c(tile ), c(tile ), c(tile )],
     [c(tile ), c(tile ), c(tile ), c(tile ), c(tile ), c(tile ), c(tile ), c(tile ), c(tile ), c(tile )]
    ]
return


##################### Definition of the TacticsCombat object, used by the combat demo #####################
init python:
  class TacticsCombat(UnitEngine):
    # Constants available before instantiation:
    # Item categories
    RANGEDWEAPON = 1
    MELEEWEAPON = 2
    HEALITEM = 3

    # Weapons used by player and enemy
    RIFLE = Struct(
      name = "Rifle",
      type = RANGEDWEAPON,
      damage = 20
      )
    LASER = Struct(
      name = "Laser",
      type = MELEEWEAPON,
      damage = 25
      )
    MEDIKIT = Struct(
      name = "Medikit",
      type = HEALITEM,
      health = 25
      )

    ################# INITIALISATION #################
    def __init__(self, **properties):
      # Do UnitEngine and TileEngine init
      UnitEngine.__init__(self, **properties)

      # Specify the callbacks
      self.callbacks.unit_destroyed = self.UnitDestroyed

      # Define the overlay
      self.unit_info = [
            self.ShowUnitName,
            (self.Tactics_IsHumanPlayerUnit, self.Tactics_ShowUnitController),
            self.ShowUnitHP,
            (self.IsPlayerUnit, self.ShowUnitMP),
            (self.IsPlayerUnit, self.ShowUnitActionsLeft),
            self.ShowUnitPosition,
            (self.IsPlayerUnit, self.Tactics_ShowUnitWeapons),
            (self.IsNonPlayerUnit, self.Tactics_ShowEnemyInfo)
              ]

      # Add fields to the map
      for tx in range(self.gxmax):
        for ty in range(self.gymax):
          self.map[tx][ty].VisibleBy = [ ]

    ################# DISPLAY #################

    def Tactics_IsHumanPlayerUnit(self):
      return (self.selected_unit.controller is self.current_player) and (self.current_player.control is self.HUMAN)

    def Tactics_ShowUnitController(self):
      ui.hbox() # Put character name and icon side-by-side
      engine_label("(" + self.selected_unit.character.name + ")", size=20, color=self.selected_unit.character.colour)
      ui.image("%s_icon.png" % self.selected_unit.character.name, xalign=1.0)
      ui.close() # End of the character name-and-icon hbox

    def Tactics_ShowUnitWeapons(self):
      engine_label("Weapons:", size=16)
      for thisWeapon in self.selected_unit.weapons:
        ui.hbox() # Item name, select button
        engine_label(thisWeapon.name, size=16, yalign=0.5)
        if self.selected_unit.selected_weapon == thisWeapon:
          ui.button(clicked=None, xfill=False)
          engine_label("Selected", size=16) #, focus=None, default=False)
        else:
          ui.button(clicked=ui.returns(self.SelectWeapon(self, thisWeapon)), xfill=False)
          engine_label("Select", size=16)
        ui.close() # End of this equipment's hbox

    def Tactics_ShowEnemyInfo(self):
      engine_label(self.selected_unit.info_string, size=16)

    ################# CALLBACKS #################

    # SelectWeapon: curried, as I need to curry which weapon into it
    @renpy.curry
    def SelectWeapon(self, weapon):
      if weapon in self.selected_unit.weapons:
        self.selected_unit.selected_weapon = weapon
        if self.mode == self.ACTMODE:
          self.SetMode(self.UNITSELECTED)

    # ActionFunction: curried, as it's returned unbound by ReturnActionFunction
    @renpy.curry
    def ActionFunction(self):
      self.HighlightSquares(self.ActCriterion, self.act_square_highlight, self.ActionSquareClicked)

    def ReturnActionFunction(self):
      return self.ActionFunction(self)

    def ActCriterion(self, pos):
      if self.selected_unit.selected_weapon == self.RIFLE:
        # Rifles hit enemies anywhere
        return self.ContainsNonPlayerUnit(pos)
      elif self.selected_unit.selected_weapon == self.MEDIKIT:
        # Medikits hit player units anywhere
        return self.ContainsPlayerUnit(pos)

    def ActionSquareClicked(self, pos):
      thisItem = self.selected_unit.selected_weapon
      if thisItem.type in [self.RANGEDWEAPON, self.MELEEWEAPON]:
        thisSquare = self.map[pos[0]][pos[1]]
        if thisSquare.unit:
          self.selected_unit.TurnToFace(pos)
          self.Show()
          self.selected_unit.character.object("Hit them!")
          self.DamageUnit(self.selected_unit.selected_weapon.damage, thisSquare.unit)
          self.FinishAction()
        else:
          self.selected_unit.character.object("Nothing found at %d,%d" % pos)
      elif thisItem.type == self.HEALITEM:
        thisSquare = self.map[pos[0]][pos[1]]
        if thisSquare.unit:
          self.selected_unit.TurnToFace(pos)
          thisSquare.unit.HP = min(thisSquare.unit.HP + thisItem.health, thisSquare.unit.max_HP)
          self.selected_unit.character.object("Hope you feel better.")
          self.FinishAction()
        else:
          self.selected_unit.character.object("There's nothing there...")

    # DalekAttack: curried, as it's returned unbound by ReturnDalekAttackFunction
    @renpy.curry
    def DalekAttack(self):
      # Lasers can hit an enemy up to 4 spaces away
      (unitx, unity), (thisx, thisy) = self.selected_unit.position, self.selected_unit.target_unit.position
      distFromTarget = abs(thisx - unitx) + abs(thisy - unity)
      if self.WithinNSpacesOf(4, self.selected_unit.target_unit.position):
        self.selected_unit.TurnToFace(self.selected_unit.target_unit)
        self.Show()
        self.selected_unit.target_unit.character.object("Aargh! It shot me!")
        self.DamageUnit(self.selected_unit.selected_weapon.damage,
                        self.selected_unit.target_unit)
        self.FinishAction()

    def ReturnDalekAttackFunction(self):
      return self.DalekAttack(self)

    def UnitDestroyed(self, unit):
      if unit.controller is self.PLAYER:
        unit.character.object("I'm... done for now...")
      else:
        if self.current_player is self.PLAYER:
          self.selected_unit.character.object("Yeah! We killed it!")