init python:
  # Declare the characters used by the demos.
  TOHKO = Struct(
    name = "Tohko",
    colour = "#ffc8c8"
  )
  tohko = Character(
    TOHKO.name,
    color=TOHKO.colour,
    show_side_image=Image("Tohko_icon.png", yalign=0.9, xalign=0.0),
    window_left_margin=130)
  TOHKO.object = tohko

  ASILANA = Struct(
    name = "Asilana",
    colour = "#ffffc0"
  )
  asilana = Character(ASILANA.name, color=ASILANA.colour)
  ASILANA.object = asilana

  # We're going to use the copy module's copy function defining our maps,
  # so it's useful to have a shorthand
  c = copy.copy

  # Set the dubious title screen.
  style.mm_root.background = Image("demos_titlescreen.png")
  style.mm_menu_frame.yalign = 0.95

  # Define the Filmstrip object that wraps around anim.Filmstrip
  # This is used for the "selected unit" highlights in both UnitEngine demos
  class MyFilmstrip(object):
    def __init__(self, **properties):
      self.stored_properties = properties
    def Create(self, displayable, **properties):
      props = self.stored_properties.copy()
      props.update(**properties)
      return anim.Filmstrip(displayable, **props)

init:
  # Define the backgrounds used.
  image black = Solid((0, 0, 0, 255))
  image blue = Solid((0, 0, 100, 255))


# Set the options
init -1:
    python hide:
        config.developer = True

        config.screen_width = 800
        config.screen_height = 600

        config.window_title = u"TileEngine and UnitEngine Demos"
        theme.roundrect(
            widget = "#8699a7",
            widget_hover = "#9eb1ad",
            widget_text = "#dcdfd6",
            widget_selected = "#ffffff",
            disabled = "#919994",
            disabled_text = "#B6BFB9",
            label = "#ffffff",
            frame = "#6f7571",
            button_menu = True,
            rounded_window = False,
            mm_root = "#b0b8ba",
            gm_root = "#b0b8ba",
            )


# The game starts here.
label start:

tohko "Welcome to the Tile Engine and Unit Engine demos!"
tohko "These demos will try to show the things that the TileEngine and UnitEngine are capable of. They don't use all the engines' features, though, so if there's something you'd like to do that's not shown in these demos, be sure to check the full documentation online, or ask Chronoluminaire."
tohko "Please excuse the placeholder graphics, by the way. They're just to demonstrate the engines' capabilities, and Chrono's not much of an artist."
tohko "We've got two TileEngine demos and two UnitEngine demos for you to choose from."
tohko "The first TileEngine demo just shows you a basic TileEngine map and the effects of the Show() and View() commands.\nThe second TileEngine demo shows a tile-based village, with some clickable sprites in it. \nThe same village is used for the first UnitEngine demo, showing a unit moving around without limits on its movement points.\nThe second UnitEngine demo shows a simple turn-based combat, so you can see the Move and Act buttons, the route-finding algorithm, and the basic AI."
while True:
  menu:
    "Which demo would you like to see?"
    "TileEngine scrolling demo":
      call TileEngineScroll from _choosedemo_menu_1
    "TileEngine village demo":
      call TileEngineVillage from _choosedemo_menu_2
    "UnitEngine village demo":
      call UnitEngineVillage from _choosedemo_menu_3
    "UnitEngine combat demo":
      call UnitEngineCombat from _choosedemo_menu_4
    "I'm done for now!":
      jump done

label done:
tohko "Thanks for looking at the TileEngine and UnitEngine demos! I hope you create wonderful things with them!"
tohko "If you have any questions or suggestions, please feel free to talk to Chronoluminaire on the Lemmasoft forums."
tohko "Bye for now!"
return
