##################### TileEngine Village demo #####################
label TileEngineVillage:
# Get the village map and buildings
call VillageMap from _TileEngineVillage_VillageMap
python:
  # Create the TileEngine
  e = TileEngine(
              geometry=Geom,
              map=map,
              tilewidth=tilewidth,
              tileheight=tileheight,
              show_cursor=True,
              cursor_sprite=cursor_sprite,
              draggable=True,
                )
  # Create the sprites
  for s in VillageBuildings:
    e.Sprite(s['sprite_name'], s['position'], clicked=ui.returns(s['activate']))

  # Show the village in the background. Don't let the user interact with it.
  e.CentreViewOn((3, 3))
  e.Show()
  #e.Show(interactions=False)
tohko "You could use something like this demo in a fantasy adventure game. Pretend you'd guided a party of adventurers into this village. Click on the different buildings to take advantage of their services. Click on the inn to finish."
# Use View() to let the user interact with the village
$ e.View(show_button=False)
# Hide the village now we're done with it
$ e.Hide()
tohko "Using the TileEngine like this doesn't actually gain you much over just using Ren'Py's built-in imagemap functionality."
tohko "But you can create any number of towns from the same fairly small set of tiles."
return


##################### UnitEngine Village demo #####################
label UnitEngineVillage:
# Get the village map and buildings
call VillageMap from _UnitEngineVillage_VillageMap
python:
  # Create the UnitEngine
  e = UnitEngine(
                geometry=Geom,
                map=map,
                tilewidth=tilewidth,
                tileheight=tileheight,
                show_cursor=True,
                cursor_sprite=cursor_sprite,
                show_buttons=False,
                show_unit_info=False,
                confirm_end_turn=True,
                moving_sprite_status="",
                movement_directions=4,
                allow_moving_through_units=True,
                move_square_highlight=move_square_highlight,
                unit_highlight=unit_highlight,
                unit_highlight_function=unit_highlight_function,
                )
  # Create the building units, based on the sprites
  # Give them a controller of ENEMY so the player can't select them
  for thisBuilding in VillageBuildings:
    thisUnit = e.Unit(
                sprite_base_name=thisBuilding['sprite_name'],
                position=thisBuilding['position'],
                clicked=e.CurriedConditionallyReturn(e, e.IsInInteraction, UEVillageMoveToSquare(thisBuilding['position'])),
                controller=UnitEngine.ENEMY)
    thisBuilding.unit = thisUnit
  # Create the scarecrow
  scarecrow = e.Unit(
                sprite_base_name="scarecrow.png",
                position=(4, 5),
                controller=UnitEngine.ENEMY,
                seen_grab=False) # We can store our own custom properties in a unit, if we want
  # Create the player's unit
  party = e.Unit(
                sprite_base_name="party.png",
                position=(1, 0),
                max_MP=9999,
                display_directions=1)
  # Store the function that grabs them when they move near something
  e.callbacks.unit_moves = UEVillageUnitMoved
  e.callbacks.mode_change = UEVillageModeChanged
  # Show the village in the background. Don't let the user interact with it.
  e.CentreViewOn((3, 3))
  e.Show(interactions=False)

  tohko("Here's the village. Just like in the TileEngine village demo, but clicking the buildings will move the party around. Or you can move around by pressing M, then using the cursor keys, and finishing with Space or Enter.")
  tohko("Like the TileEngine village demo, go to the inn to end.")
  # Give the UnitEngine control
  e.StartGame()

return


# Define the functions used by the UnitEngine
init python:
  @renpy.curry
  def UEVillageMoveToSquare(position):
    party.MoveToSquare(position, spend_MP=False)

  def UEVillageUnitMoved(unit, (x, y)):
    if unit is not party:
      return
    for thisBuilding in VillageBuildings:
      bx, by = thisBuilding['position']
      if abs(bx - x) + abs(by - y) <= 1:
        # They've walked up to this building
        thisBuilding['activate']()
    if (x, y) == scarecrow.position and not scarecrow.seen_grab:
      tohko("The scarecrow suddenly grabs you as you walk past!")
      tohko("...PSYCH!")
      tohko("It doesn't really. But this shows how you can use the UnitEngine's unit_moves callback to trigger off the player moving through specific regions.")
      scarecrow.seen_grab = True

  def UEVillageModeChanged():
    if e.mode in [e.NOSELECTION]:
      # If the player deselects the party, reselect them
      e.SelectUnit(party)

##################### Shared Village demo code #####################
label VillageMap:
python:
  move_square_highlight = ("tile-highlight-straight-blue.png","tile-highlight-straight-blue-selected.png")
  act_square_highlight = ("tile-highlight-straight-red.png", "tile-highlight-straight-red-selected.png")
  f = MyFilmstrip(framesize=(64,64), gridsize=(2,3), delay=0.1)
  unit_highlight = im.Alpha("tile-highlight-straight-green-animstrip.png", 0.5)
  unit_highlight_function = f.Create
  cursor_sprite = "cursor-straight.png"
  Geom = TileEngine.STRAIGHT
  tilewidth = 64
  tileheight = 64

  # Provide the village definitions of the tiles:
  # grass counts as wall, since we want the player to follow the roads
  rock = Struct(
    terrain_type = UnitEngine.TT_GROUND,
    lower = "tile-rocks-straight.png",
    upper = None)
  grass = Struct(
    terrain_type = UnitEngine.TT_WALL,
    lower = "tile-grass-straight.png",
    upper = None)
  rock = Struct(
    terrain_type = UnitEngine.TT_WALL,
    lower = "tile-rocks-straight.png",
    upper = None)
  gtree = Struct(
    terrain_type = UnitEngine.TT_WALL,
    lower = "tile-grass-straight.png",
    upper = "abovetile-tree.png")
  # House is an alias for grass, since the buildings are added as sprites
  house = grass
  # Roads:
  r_ns = Struct(
    terrain_type = UnitEngine.TT_GROUND,
    lower = "tile-road-ns.png",
    upper = None)
  r_ew = Struct(
    terrain_type = UnitEngine.TT_GROUND,
    lower = "tile-road-ew.png",
    upper = None)
  rnsew = Struct(
    terrain_type = UnitEngine.TT_GROUND,
    lower = "tile-road-nsew.png",
    upper = None)
  r_ne = Struct(
    terrain_type = UnitEngine.TT_GROUND,
    lower = "tile-road-ne.png",
    upper = None)
  r_nw = Struct(
    terrain_type = UnitEngine.TT_GROUND,
    lower = "tile-road-nw.png",
    upper = None)
  r_se = Struct(
    terrain_type = UnitEngine.TT_GROUND,
    lower = "tile-road-se.png",
    upper = None)
  r_sw = Struct(
    terrain_type = UnitEngine.TT_GROUND,
    lower = "tile-road-sw.png",
    upper = None)
  r_nse = Struct(
    terrain_type = UnitEngine.TT_GROUND,
    lower = "tile-road-nse.png",
    upper = None)

  map = [
    [c(gtree),  c(r_ns), c(grass), c(gtree), c(grass), c(grass), c(grass), c(grass), c(grass), c(grass)],
    [c(grass), c(r_nse),  c(r_ew),  c(r_ew),  c(r_ew),  c(r_ew),  c(r_ew), c(house), c(grass), c(grass)],
    [c(grass),  c(r_ns), c(gtree), c(grass), c(grass), c(grass), c(grass), c(grass), c(gtree), c(grass)],
    [c(gtree),  c(r_ne),  c(r_ew),  c(r_ew),  c(r_sw), c(grass), c(house), c(house), c(house), c(gtree)],
    [c(grass), c(grass), c(gtree), c(grass),  c(r_ns), c(grass), c(grass),  c(r_ns), c(grass), c(grass)],
    [c(house), c(house), c(house), c(grass), c(r_nse),  c(r_ew),  c(r_ew), c(rnsew),  c(r_ew),  c(r_ew)],
    [c(grass),  c(r_ns), c(grass), c(grass),  c(r_ns), c(gtree), c(grass),  c(r_ns), c(grass), c(gtree)],
    [c(grass),  c(r_ne),  c(r_ew),  c(r_ew),  c(r_nw), c(grass), c(house), c(house), c(house), c(grass)]
    ]
  # Transpose the map, so that it's actually laid out as it looks
  map = zip(*map)

  VillageBuildings = [
    {"name": "pub", "sprite_name": "pub.png", "position": (1, 6), "activate": VisitPub},
    {"name": "inn", "sprite_name": "inn.png", "position": (7, 3), "activate": VisitInn},
    {"name": "armoury", "sprite_name": "armoury.png", "position": (6, 1), "activate": VisitArmoury},
    {"name": "magicshop", "sprite_name": "magicshop.png", "position": (7, 7), "activate": VisitMagicShop},
    ]
return

init python:
  def VisitPub():
    tohko("Ah, a pub.")
    tohko("A fine location for gathering information, getting to know the local culture, and relaxing.")
    return
  def VisitInn():
    tohko("For some reason, an inn is different to a pub. The inn doesn't even have a bar, it's just a place to get some sleep.")
    tohko("Which you decide to do. Night-night.")
    # This function ends both the TileEngine village demo and the UnitEngine village demo.
    # To quit a UnitEngine's game, the MODE needs to be VICTORY or DEFEAT;
    e.mode = UnitEngine.VICTORY
    # To leave a TileEngine's View(), make the clicked function return True.
    return True
  def VisitArmoury():
    tohko("The armoury is a place to stock up on all your swords, maces, armour, and other metallic objects.")
    tohko("And probably bizarre things like cards and paintbrushes too, if you're that way inclined.")
    return
  def VisitMagicShop():
    tohko("Now this is my kind of place! Potions, wands, scrolls, orbs, enchanted mirrors and magic items of every description line the walls.")
    return

